@extends('backoffice.dashboard')
@section('content')
<link rel="stylesheet" href="{{ asset('BackOfficeAR/css/formulaire.css') }}">
@if ($errors->any())
    <ul class="alert alert-warning">
        @foreach ($errors->all() as $error)
            <li>{{ $error }}</li>
        @endforeach
    </ul>
@endif
@if(Auth::check())

<div class="container">
    <form action="{{ route('admin.doc_fin.store') }}" method="POST" enctype="multipart/form-data" lang="ar">
    @csrf
        <input type="hidden" name="id_formulaire" value="{{ $formulaire->id_type }}">
        <input type="hidden" name="id_projet" value="{{ $id_projet }}">
        <h2>الجمهورية التونسية</h2>
        <h2>وزارة الشباب و الرياضة</h2>
        <h3 style="font-size:25px;">{{ $formulaire->type_ar }}</h3>
        <br>
        <div class="form-section">
            <div class="form-group row">
                <table id="phase-table" class="custom-table table table-bordered text-center">
                    <thead>
                        <tr>
                            <th>#</th> 
                            <th> الوثائق حسب الامر عدد 5183 </th>
                            <th> الوثائق </th>
                            <th> الملاحظات </th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($typedocum as $index => $doc)
                        <tr>
                            <td class="row-number">{{ $index + 1 }}</td>
                            
                            <td data-label="الوثائق حسب الامر عدد 5183">
                                {{ $doc->type_ar }}
                                <input type="hidden" name="doc_fin[{{ $index }}][id_doc]" value="{{ $doc->id_type_doc }}">
                            </td>

                            <td data-label="الوثائق">
                                @php
                                    $docExist = $documents->where('id_doc', $doc->id_type_doc)->first();
                                @endphp

                                @if(in_array($doc->id_type_doc, [15,17]))
                                    ✅ هذا الملف متوفر بالفعل

                                @elseif($doc->id_type_doc == 16)
                                <div style="display:flex; align-items:center; gap:10px;">
                                    <a href="{{ asset('storage/documents_financement/التزام_وتصريح_على_الشرف.pdf') }}" 
                                    target="_blank" 
                                    class="btn btn-sm btn-secondary" 
                                    title="Télécharger le document">
                                        📤
                                    </a>

                                    <input type="file" name="doc_fin[{{ $index }}][file]" class="form-control" style="flex:1">
                                </div>

                                @else
                                    <input type="file" name="doc_fin[{{ $index }}][file]" class="form-control">
                                @endif
                            </td>

                            <td data-label="الملاحظات">
                                <input type="text" name="doc_fin[{{ $index }}][remarques]" class="form-control" maxlength="100"
                                    value="{{ $docExist->remarques ?? '' }}">
                            </td>
                        </tr>
                        @endforeach
                        </tbody>

                </table>
            </div>
        </div>

        <div class="form-group row text-center" style="padding-top:50px;">
            <div class="col-sm-4 mx-auto">
                <button type="submit" class="btn btn-success font-weight-medium" style="width:100px;margin-right:250px;">إرسال</button>
            </div>
            <div class="col-sm-4 mx-auto">
                <a href="{{ route('admin.doc_fin.index') }}" class="btn btn-primary" style="width:100px;margin-left:250px;">
                    <i class="bi bi-arrow-left"></i> رجوع
                </a>
            </div>
        </div>
    </form>
</div>

@else
    <script>
        window.location.href = "{{ route('login') }}";
    </script>
@endif
@endsection